package com.company.controllers;

import com.company.exceptions.DataConsistencyException;
import com.company.model.*;
import com.company.views.*;
import javafx.util.Pair;

import java.util.List;

public class Controller {
    private School model;
    private View view;
    private StudentView studentView;
    private InstructorView instructorView;
    private SubjectView subjectView;
    private EnrollView enrollView;
    private LectureView lectureView;

    public Controller(School school){
        this.model = school;
    }

    public  void  run(){
        int op = -1;
        do{
            op=this.view.menuSchool();
            switch(op){
                case 1:runStudents();
                    break;
                case 2:runInstructors();
                    break;
                case 3:runSubjects();
                    break;
                case 4:runEnrolls();
                    break;
                default:
                    break;
            }
        }while(op!=0);

    }

  private void  runStudents(){


        int op = -1;
        do{
            op = this.view.menuStudents();

            switch(op){
                case 1:	{
                    Student student = this.studentView.getStudent();
                    StudentContainer container = this.model.getStudentContainer();
                    container.add(student);
                }
                break;
                case 2:{
                    int number = Utils.getNumber("Enter the Student Number");
                    StudentContainer container = this.model.getStudentContainer();
                    Student  ptr = container.get(number);
                    if(ptr != null){
                        this.studentView.printStudent(ptr);
                    }else{
                        String msg = "Student [" + number + "] does not exist.";
                        this.studentView.printError(msg);
                    }
                }
                break;
                case 3:{
                    try{
                        int number = Utils.getNumber("Enter the Student Number");
                        StudentContainer container = this.model.getStudentContainer();
                        container.remove(number);
                    }catch(DataConsistencyException e){
                        String str = e.what();
                        Utils.printString(str);
                    }
                }
                break;
                case 4:{
                    int number = Utils.getNumber("Enter the Student Number");
                    String name =  Utils.getString("Enter the Student Name");
                    Date date = this.studentView.getDate();
                    StudentContainer container = this.model.getStudentContainer();
                    container.update(number,name, date);
                }
                break;
                case 5:
                {
                    Utils.printString(this.model.getName());
                    StudentContainer container = this.model.getStudentContainer();
                    List<Student> students = container.getAll();
                    this.studentView.printStudents(students);

                }
                break;
                default:
                    break;
            }
        }while(op!=0);
    }

    private void  runInstructors(){

        int op = -1;
        do{
            op = this.view.menuInstructors();

            switch(op){
                case 1:	{
                    Instructor instructor = this.instructorView.getInstructor();
                    InstructorContainer container = this.model.getInstructorContainer();
                    container.add(instructor);
                }
                break;
                case 2:{
                    String initials = Utils.getString("Enter the Instructor Initials");
                    InstructorContainer container = this.model.getInstructorContainer();
                    Instructor ptr = container.get(initials);
                    if(ptr != null){
                        this.instructorView.printInstructor(ptr);
                    }else{
                        String msg = "Instructor ["+ initials +"] does not exist.";
                        this.instructorView.printError(msg);
                    }
                }
                break;
                case 3:{
                    try{
                        String initials = Utils.getString("Enter the Instructor Initials");
                        InstructorContainer container = this.model.getInstructorContainer();
                        container.remove(initials);
                    }catch(DataConsistencyException e){
                        String str = e.what();
                        Utils.printString(str);
                    }
                }
                break;
                case 4:{
                    String initials = Utils.getString("Enter the Instructor Initials");
                    String name =  Utils.getString("Enter the Instructor Name");
                    InstructorContainer container = this.model.getInstructorContainer();
                    container.update(initials,name);
                }
                break;
                case 5:
                {
                    Utils.printString(this.model.getName());
                    InstructorContainer container = this.model.getInstructorContainer();
                    List<Instructor> instructors = container.getAll();
                    this.instructorView.printInstructors(instructors);

                }
                break;

                case 6:runLectures();
                    break;
                default:
                    break;
            }
        }while(op!=0);
    }
    private void  runSubjects(){


        int op = -1;
        do{
            op = this.view.menuSubjects();

            switch(op){
                case 1:	{
                    Subject subject = this.subjectView.getSubject();
                    SubjectContainer container = this.model.getSubjectContainer();
                    container.add(subject);
                }
                break;
                case 2:{
                    String initials = Utils.getString("Enter the Subject Initials");
                    SubjectContainer container = this.model.getSubjectContainer();
                    Subject  ptr = container.get(initials);
                    if(ptr != null){
                        this.subjectView.printSubject(ptr);
                    }else{
                        String msg = "Subject ["+ initials +"] does not exist.";
                        this.subjectView.printError(msg);
                    }
                }
                break;
                case 3:{
                    try{
                        String initials = Utils.getString("Enter the Subject Initials");
                        SubjectContainer container = this.model.getSubjectContainer();
                        container.remove(initials);
                    }catch(DataConsistencyException e){
                        String str = e.what();
                        Utils.printString(str);
                    }
                }
                break;
                case 4:{
                    String initials = Utils.getString("Enter the Subject Initials");
                    String designation =  Utils.getString("Enter the Subject Designation");
                    SubjectContainer container = this.model.getSubjectContainer();
                    container.update(initials,designation);
                }
                break;
                case 5:
                {
                    Utils.printString(this.model.getName());
                    SubjectContainer container = this.model.getSubjectContainer();
                    List<Subject> subjects = container.getAll();
                    this.subjectView.printSubjects(subjects);

                }
                break;

                default:
                    break;
            }
        }while(op!=0);
    }
    private void  runEnrolls(){


        int op = -1;
        do{
            op = this.view.menuEnrolls();

            switch(op){
                case 1:	{
                    Enroll enroll = this.enrollView.getEnroll(this.model.getStudentContainer(), this.model.getSubjectContainer());
                    EnrollContainer container = this.model.getEnrollContainer();
                    container.add(enroll);
                }
                break;
                case 2:{
                    int number = Utils.getNumber("Enter Student Number");
                    String initials = Utils.getString("Enter Subject Initials");
                    EnrollContainer container = this.model.getEnrollContainer();
                    Enroll ptr = container.get(number, initials);
                    if(ptr != null){
                        this.enrollView.printEnroll(ptr);
                    }else{
                        String msg = "Enroll ["+ initials +"] does not exist.";
                        this.enrollView.printError(msg);
                    }
                }
                break;
                case 3:{
                    try{
                        int number = Utils.getNumber("Enter Student Number");
                        String initials = Utils.getString("Enter Subject Initials");
                        EnrollContainer container = this.model.getEnrollContainer();
                        container.remove(number, initials);
                    }catch(DataConsistencyException e){
                        String str = e.what();
                        Utils.printString(str);
                    }
                }
                break;
                case 4:
                {
                    Utils.printString(this.model.getName());
                    EnrollContainer container = this.model.getEnrollContainer();
                    List<Enroll> enrolls = container.getAll();
                    this.enrollView.printEnrolls(enrolls);

                }
                break;
                case 5:
                {
                    int number = Utils.getNumber("Enter Student Number");
                    StudentContainer container = this.model.getStudentContainer();
                    Student  student = container.get(number);
                    if(student != null){
                        EnrollContainer container1 = this.model.getEnrollContainer();
                        List<Pair<Subject, Integer>> l = container1.getSubjects(number);
                        this.enrollView.printStudentEnrolls(student, l);
                    }


                }
                break;
                case 6:
                {
                    String initials = Utils.getString("Enter Subject Initials");
                    SubjectContainer container = this.model.getSubjectContainer();
                    Subject  subject = container.get(initials);
                    if(subject != null){
                        EnrollContainer container1 = this.model.getEnrollContainer();
                        List<Pair<Student, Integer>> l  = container1.getStudents(initials);
                        this.enrollView.printSubjectEnrolls(subject, l);
                    }


                }
                break;


                default:
                    break;
            }
        }while(op!=0);
    }

    private void  runLectures(){


        int op = -1;
        do{
            op = this.view.menuLectures();

            switch(op){
                case 1:	{
                    String initials = Utils.getString("Enter the Instructor Initials");
                    InstructorContainer container = this.model.getInstructorContainer();
                    Instructor  instructor = container.get(initials);
                    if(instructor != null){
                        Lecture lecture = this.lectureView.getLecture(this.model.getSubjectContainer());
                        LectureContainer container1 = instructor.getLectures();
                        container1.add(lecture);
                    }else{
                        String msg = "Instructor ["+ initials +"] does not exist.";
                        this.lectureView.printError(msg);
                    }
                }
                break;
                case 2:{
                    String initials = Utils.getString("Enter the Instructor Initials");
                    InstructorContainer container = this.model.getInstructorContainer();
                    Instructor  instructor = container.get(initials);
                    if(instructor != null){
                        String initials1 = Utils.getString("Enter the Subject Initials");
                        LectureContainer container1 = instructor.getLectures();
                        container1.remove(initials1);
                    }else{
                        String msg = "Instructor ["+ initials +"] does not exist.";
                        this.lectureView.printError(msg);
                    }
                }
                break;
                case 3:	{
                    String initials = Utils.getString("Enter the Instructor Initials");
                    InstructorContainer container = this.model.getInstructorContainer();
                    Instructor  instructor = container.get(initials);
                    if(instructor != null){
                        LectureContainer container1 = instructor.getLectures();
                        List<Lecture> listLecture = container1.getAll();
                        this.lectureView.printLectures(instructor, listLecture);
                    }else{
                        String msg = "Instructor ["+ initials +"] does not exist.";
                        this.lectureView.printError(msg);
                    }
                }
                break;
                default:
                    break;
            }
        }while(op!=0);
    }
}
